'use strict'

entityRegistry['module']['reference'] = {
    extendedInfo: {
        displayName: 'Reference',
        displayGroup: 'Core',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
        { paramName: 'moduleId', displayName: 'Module Id', type: 'string', defaultValue: '', triggerInit: false },
        { paramName: 'enableTime', displayName: 'Enable Time', type: 'boolean', defaultValue: false, triggerInit: false },
    ],
    dynamicConfig: [
        { paramName: 'time', displayName: 'Time', type: 'float', defaultValue: 0},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                moduleId,
                enableTime,
                time,
            } = { ...config }

            moduleRunStringsIndent++

            if (enableTime) {
                frameTime = time
            }

            const eah = EntityAccessHelper.fromUuid(moduleId)
            if (eah.exists) {
                const perfStartTime = window.performance.now()

                const entityFrameTime = frameTime
                if (eah.staticConfig.enabled && entityFrameTime >= 0 && entityFrameTime < eah.staticConfig.duration) {
                    const modulesRunStringsIndex = modulesRunStrings.length
                    modulesRunStrings.push(null)

                    try {
                        eah.actions.render(
                            eah.self,
                            entityFrameTime,
                            eah.combinedConfigs(entityFrameTime),
                            ctx)
                    } catch (e) {
                        console.log(`Rendering failed for: ${moduleId}, ${eah.type}:${eah.subType}, '${e}'`)
                    }

                    const perfEndTime = window.performance.now()
                    const perfDuration = perfEndTime - perfStartTime
                    modulesRunStrings[modulesRunStringsIndex] = [moduleRunStringsIndent, eah.name, perfDuration, moduleId]
                }
            }

            moduleRunStringsIndent--
        }
    }
}
